/* cirbuf.h
 *
 * Copyright (C) DFS Deutsche Flugsicherung (2004, 2005). 
 * All Rights Reserved.
 *
 * Circular Buffers
 *
 * Version 0.2
 */
#ifndef _CIRBUF_H

// must be multiple of FRAGSIZE and FRAMESIZE
#define CIRBUFSIZE	(WIDEB*2*80*8*2)  

/* circular buffer for FRAGSIZE to FRAMESIZE conversion with 
 * overrun/underrun */
class CIRBUF {
  char buf[CIRBUFSIZE];         // must be multiple of FRAGSIZE and FRAMESIZE
  int in;
  int out;
  int len;

public:
   CIRBUF();
  void CIRBUF::init();
  int CIRBUF::push(char *from, int size);
  int CIRBUF::pop(char *to, int size);
  int getlen() {
    return len;
  }
};

#define _CIRBUF_H
#endif
