/* rtp.h
 *
 * Copyright (C) DFS Deutsche Flugsicherung (2004, 2005). 
 * All Rights Reserved.
 * Author: Andre Adrian
 *
 * subset of Real Time Protocol Version 2 (RFC3550 and RFC3551)
 * handling of extension and padding is missing
 *
 * Version 0.3.5
 */

class RTP {
  /* Format in Host Byte order. Conversion with htonl() to Network Byte
   * order. This data structure is implementation dependent! 
   * Tested with GCC and x86 */

  /* first 32bits */
  unsigned long sequence:16;
  unsigned long payload_type:7;
  unsigned long marker:1;
  unsigned long csrc_count:4;
  unsigned long extension:1;
  unsigned long padding:1;
  unsigned long version:2;

  /* second 32bits */
  unsigned long timestamp;

  /* third 32bits */
  unsigned long ssrc;  /* used as unique identifier */
  
  /* optional - used with telephone conference */
  unsigned long csrc[15];

public:
   RTP();
  void init(int payload_type_, unsigned long ssrc_);
  int add_csrc(unsigned long csrc_);
  void reset_csrc();
  int find_csrc(unsigned long ssrc_);
  void next(int frameduration);
  int check();
  unsigned long getssrc() {
    return ssrc;
  };
  int get_pt() {
    return (int) payload_type;
  };
  int get_cc() {
    return (int) csrc_count;
  }
};

const unsigned PT_PCMU = 0;     // 8000 sample/second, G.711 u-Law
const unsigned PT_GSM =  3;     // 8000 sample/second, GSM
const unsigned PT_PCMA = 8;     // 8000 sample/second, G.711 A-Law
const unsigned PT_G729 = 18;    // 8000 sample/second, G.729
const unsigned PT_EFR =  97;    // inofficial type GSM-EFR
const unsigned PT_iLBC = 98;    // inofficial type iLBC 20ms
const unsigned PT_G726 = 99;    // inofficial type G.726 32kbps
const unsigned PT_SPX =  101;   // inofficial type Wideband Speex

// Speex Wideband kbps/Bytes: 16.8/42, 20.6/52, 23.8/60, 27.8/70, 
// 34.2/86, 42.2/106
const int SPX_BITRATE = 27800;
const int SPX_COMPLEXITY = 3;
const int SPX_QUALITY = 8;
const int SPX_ENH = 1;

#define SZ_PCMA 160
#define SZ_PCMU 160
#define SZ_G726 80
#define SZ_GSM  33
#define SZ_EFR  31
#define SZ_SPX  70
#define SZ_iLBC 38

char *RTP_network_copy(char *to, RTP * from);
char *RTP_host_copy(RTP * to, char *from);
unsigned long random32(int type);
