
/*
  RFC3551:
  
   name of                              sampling              default
   encoding  sample/frame  bits/sample      rate  ms/frame  ms/packet
   __________________________________________________________________
   GSM       frame         N/A             8,000        20         20
  

               field  field name  bits  field  field name  bits
               ________________________________________________
               1      LARc[0]     6     39     xmc[22]     3
               2      LARc[1]     6     40     xmc[23]     3
               3      LARc[2]     5     41     xmc[24]     3
               4      LARc[3]     5     42     xmc[25]     3
               5      LARc[4]     4     43     Nc[2]       7
               6      LARc[5]     4     44     bc[2]       2
               7      LARc[6]     3     45     Mc[2]       2
               8      LARc[7]     3     46     xmaxc[2]    6
               9      Nc[0]       7     47     xmc[26]     3
               10     bc[0]       2     48     xmc[27]     3
               11     Mc[0]       2     49     xmc[28]     3
               12     xmaxc[0]    6     50     xmc[29]     3
               13     xmc[0]      3     51     xmc[30]     3
               14     xmc[1]      3     52     xmc[31]     3
               15     xmc[2]      3     53     xmc[32]     3
               16     xmc[3]      3     54     xmc[33]     3
               17     xmc[4]      3     55     xmc[34]     3
               18     xmc[5]      3     56     xmc[35]     3
               19     xmc[6]      3     57     xmc[36]     3
               20     xmc[7]      3     58     xmc[37]     3
               21     xmc[8]      3     59     xmc[38]     3
               22     xmc[9]      3     60     Nc[3]       7
               23     xmc[10]     3     61     bc[3]       2
               24     xmc[11]     3     62     Mc[3]       2
               25     xmc[12]     3     63     xmaxc[3]    6
               26     Nc[1]       7     64     xmc[39]     3
               27     bc[1]       2     65     xmc[40]     3
               28     Mc[1]       2     66     xmc[41]     3
               29     xmaxc[1]    6     67     xmc[42]     3
               30     xmc[13]     3     68     xmc[43]     3
               31     xmc[14]     3     69     xmc[44]     3
               32     xmc[15]     3     70     xmc[45]     3
               33     xmc[16]     3     71     xmc[46]     3
               34     xmc[17]     3     72     xmc[47]     3
               35     xmc[18]     3     73     xmc[48]     3
               36     xmc[19]     3     74     xmc[49]     3
               37     xmc[20]     3     75     xmc[50]     3
               38     xmc[21]     3     76     xmc[51]     3

                      Table 2: Ordering of GSM variables
                      

   Octet  Bit 0   Bit 1   Bit 2   Bit 3   Bit 4   Bit 5   Bit 6   Bit 7
   _____________________________________________________________________
       0    1       1       0       1    LARc0.0 LARc0.1 LARc0.2 LARc0.3
       1 LARc0.4 LARc0.5 LARc1.0 LARc1.1 LARc1.2 LARc1.3 LARc1.4 LARc1.5
       2 LARc2.0 LARc2.1 LARc2.2 LARc2.3 LARc2.4 LARc3.0 LARc3.1 LARc3.2
       3 LARc3.3 LARc3.4 LARc4.0 LARc4.1 LARc4.2 LARc4.3 LARc5.0 LARc5.1
       4 LARc5.2 LARc5.3 LARc6.0 LARc6.1 LARc6.2 LARc7.0 LARc7.1 LARc7.2
       5  Nc0.0   Nc0.1   Nc0.2   Nc0.3   Nc0.4   Nc0.5   Nc0.6  bc0.0
       6  bc0.1   Mc0.0   Mc0.1  xmaxc00 xmaxc01 xmaxc02 xmaxc03 xmaxc04
       7 xmaxc05 xmc0.0  xmc0.1  xmc0.2  xmc1.0  xmc1.1  xmc1.2  xmc2.0
       8 xmc2.1  xmc2.2  xmc3.0  xmc3.1  xmc3.2  xmc4.0  xmc4.1  xmc4.2
       9 xmc5.0  xmc5.1  xmc5.2  xmc6.0  xmc6.1  xmc6.2  xmc7.0  xmc7.1
      10 xmc7.2  xmc8.0  xmc8.1  xmc8.2  xmc9.0  xmc9.1  xmc9.2  xmc10.0
      11 xmc10.1 xmc10.2 xmc11.0 xmc11.1 xmc11.2 xmc12.0 xmc12.1 xcm12.2
      12  Nc1.0   Nc1.1   Nc1.2   Nc1.3   Nc1.4   Nc1.5   Nc1.6   bc1.0
      13  bc1.1   Mc1.0   Mc1.1  xmaxc10 xmaxc11 xmaxc12 xmaxc13 xmaxc14
      14 xmax15  xmc13.0 xmc13.1 xmc13.2 xmc14.0 xmc14.1 xmc14.2 xmc15.0
      15 xmc15.1 xmc15.2 xmc16.0 xmc16.1 xmc16.2 xmc17.0 xmc17.1 xmc17.2
      16 xmc18.0 xmc18.1 xmc18.2 xmc19.0 xmc19.1 xmc19.2 xmc20.0 xmc20.1
      17 xmc20.2 xmc21.0 xmc21.1 xmc21.2 xmc22.0 xmc22.1 xmc22.2 xmc23.0
      18 xmc23.1 xmc23.2 xmc24.0 xmc24.1 xmc24.2 xmc25.0 xmc25.1 xmc25.2
      19  Nc2.0   Nc2.1   Nc2.2   Nc2.3   Nc2.4   Nc2.5   Nc2.6   bc2.0
      20  bc2.1   Mc2.0   Mc2.1  xmaxc20 xmaxc21 xmaxc22 xmaxc23 xmaxc24
      21 xmaxc25 xmc26.0 xmc26.1 xmc26.2 xmc27.0 xmc27.1 xmc27.2 xmc28.0
      22 xmc28.1 xmc28.2 xmc29.0 xmc29.1 xmc29.2 xmc30.0 xmc30.1 xmc30.2
      23 xmc31.0 xmc31.1 xmc31.2 xmc32.0 xmc32.1 xmc32.2 xmc33.0 xmc33.1
      24 xmc33.2 xmc34.0 xmc34.1 xmc34.2 xmc35.0 xmc35.1 xmc35.2 xmc36.0
      25 Xmc36.1 xmc36.2 xmc37.0 xmc37.1 xmc37.2 xmc38.0 xmc38.1 xmc38.2
      26  Nc3.0   Nc3.1   Nc3.2   Nc3.3   Nc3.4   Nc3.5   Nc3.6   bc3.0
      27  bc3.1   Mc3.0   Mc3.1  xmaxc30 xmaxc31 xmaxc32 xmaxc33 xmaxc34
      28 xmaxc35 xmc39.0 xmc39.1 xmc39.2 xmc40.0 xmc40.1 xmc40.2 xmc41.0
      29 xmc41.1 xmc41.2 xmc42.0 xmc42.1 xmc42.2 xmc43.0 xmc43.1 xmc43.2
      30 xmc44.0 xmc44.1 xmc44.2 xmc45.0 xmc45.1 xmc45.2 xmc46.0 xmc46.1
      31 xmc46.2 xmc47.0 xmc47.1 xmc47.2 xmc48.0 xmc48.1 xmc48.2 xmc49.0
      32 xmc49.1 xmc49.2 xmc50.0 xmc50.1 xmc50.2 xmc51.0 xmc51.1 xmc51.2

                        Table 3: GSM payload format

   In the GSM packing used by RTP, the bits SHALL be packed beginning
   from the most significant bit.  Every 160 sample GSM frame is coded
   into one 33 octet (264 bit) buffer.  Every such buffer begins with a
   4 bit signature (0xD), followed by the MSB encoding of the fields of
   the frame.  The first octet thus contains 1101 in the 4 most
   significant bits (0-3) and the 4 most significant bits of F1 (0-3) in
   the 4 least significant bits (4-7).

   
               PT   encoding    media type  clock rate   channels
                    name                    (Hz)
               ___________________________________________________
               3    GSM         A            8,000       1
   
 */
 
typedef unsigned char Byte;

static Byte byte;
static unsigned mask;
static Byte *packed;
static int gsmbits[76] = {
  6, 6, 5, 5, 4, 4, 3, 3, 7, 2, 2, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 7, 2, 2, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 7, 2, 2, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 2,
  2, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
};

static void pack(short data, int len)
{
  unsigned srcmask;
  
  for (srcmask = (1 << len-1); srcmask > 0; srcmask /= 2) {
    if (data & srcmask) {
      byte += mask;
    }
    mask /= 2;                  // shift right
    if (0 == mask) {
      *packed = byte;
      ++packed;
      mask = 128;
      byte = 0;
    }
  }
}

int gsmpack(Byte *gsm_frame, short *rpe_frame)
{
  int i;
  
  byte = 0;
  mask = 128;  
  packed = gsm_frame;
  
  pack(0xD, 4);   // GSM signature
  for (i = 0; i < 76; ++i, ++rpe_frame) {
    pack(*rpe_frame, gsmbits[i]);
  }
  *packed = byte;
  
  return 33;
}

static short unpack(int len)
{
  unsigned srcmask;
  short data = 0;
  
  for (srcmask = (1 << len-1); srcmask > 0; srcmask /= 2) {
    if ((*packed) & mask) {
      data += srcmask;
    }
    mask /= 2;                  // shift right
    if (0 == mask) {
      ++packed;
      mask = 128;
    }
  }
  
  // fprintf(stderr, "data =%x\n", data);
  return data;
}

int gsmunpack(short *rpe_frame, Byte *gsm_frame)
{
  int i;
  
  byte = 0;
  mask = 128;  
  packed = gsm_frame;
  
  if (unpack(4) != 0xD) {
    // fprintf(stderr, "error: gsmunpack\n");
    return 0; // not GSM signature
  }
  for (i = 0; i < 76; ++i, ++rpe_frame) {
    *rpe_frame = unpack(gsmbits[i]);
  }
  // exit(1)  ;
  return 160; // number of PCM samples
}



