#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/mman.h>

#include "linux/fb.h"

#include "common.h"

int main(int argc, char *argv[]) {

  if (argc != 2) {
    fprintf(stderr, "usage: fbt /dev/fbX\n");
    exit(EXIT_FAILURE);
  }

  int fd = open(argv[1], O_RDWR);
  if (fd < 0) {
    perror("");
    exit(EXIT_FAILURE);
  }
  
  struct fb_fix_screeninfo sif;
  if (ioctl(fd, FBIOGET_FSCREENINFO, &sif) < 0) {
    perror("");
    exit(EXIT_FAILURE);
  }

  printf("id %s\n", sif.id);
  printf("type %d, aux %d\n", sif.type, sif.type_aux);
  printf("visual %d\n", sif.visual);
  printf("accel %d\n", sif.accel);
  printf("line length %d\n", sif.line_length);
  printf("mem %d\n", sif.smem_len);

  struct fb_var_screeninfo siv;
  if (ioctl(fd, FBIOGET_VSCREENINFO, &siv) < 0) {
    perror("");
    exit(EXIT_FAILURE);
  }

  printf("res x %d y %d\n", siv.xres, siv.yres);
  printf("bpp %d\n", siv.bits_per_pixel);

  size_t fb_mem_size = siv.xres * siv.yres * siv.bits_per_pixel / 8;
  void *fb_mem = mmap(NULL, fb_mem_size, PROT_READ | PROT_WRITE, MAP_SHARED, fd, 0);
  if (fb_mem == MAP_FAILED) {
    perror("");
    exit(EXIT_FAILURE);
  }

  printf("-------------\n");
  fflush(stdout);

  jpg_buf_t jpg_buf = build_jpg_from_fb((unsigned char *)fb_mem, siv.xres, siv.yres, siv.bits_per_pixel);

  munmap(fb_mem, fb_mem_size);
  close(fd);

  printf("jpg %ld\n", jpg_buf.size);

  FILE *f = fopen("test.jpg", "wb");
  if (!f) {
	fprintf(stderr, "fopen failed\n");
    exit(EXIT_FAILURE);
  }

  fwrite(jpg_buf.ptr, 1, jpg_buf.size, f);

  fclose(f);

  free(jpg_buf.ptr);

  exit(EXIT_SUCCESS);
}
