#ifndef PECK_FFTR_H
#define PECK_FFTR_H

#include "peck_fft.h"

#ifdef __cplusplus
extern "C" {
#endif
    
/* 
 * Real optimized version can save about 45% cpu time vs. complex fft of a real seq.
 */
typedef struct peck_fftr_state *peck_fftr_cfg;

/* 
 * peck_fftr_alloc()
 * nfft must be even
 *
 * If you don't care to allocate space, use mem = lenmem = NULL.
 */
peck_fftr_cfg peck_fftr_alloc(int nfft, int inverse_fft, void * mem, size_t * lenmem);

/*
 * peck_fftr()
 * input timedata has nfft scalar points
 * output freqdata has nfft/2+1 complex points
 */
void peck_fftr(peck_fftr_cfg cfg,const peck_fft_scalar *timedata, peck_fft_cpx *freqdata);

/*
 * peck_fftri()
 * input freqdata has  nfft/2+1 complex points
 * output timedata has nfft scalar points
 */
void peck_fftri(peck_fftr_cfg cfg,const peck_fft_cpx *freqdata, peck_fft_scalar *timedata);

#define peck_fftr_free free

#ifdef __cplusplus
}
#endif

#endif /* PECK_FFTR_H */
