import numpy
import math

JPEG_luma_Q = numpy.array(
    [[16,  11,  10,  16,  24,  40,  51,  61],
    [12,  12,  14,  19,  26,  58,  60,  55],
    [14,  13,  16,  24,  40,  57,  69,  56],
    [14,  17,  22,  29,  51,  87,  80,  62],
    [18,  22,  37,  56,  68, 109, 103,  77],
    [24,  35,  55,  64,  81, 104, 113,  92],
    [49,  64,  78,  87, 103, 121, 120, 101],
    [72,  92,  95,  98, 112, 100, 103,  99]])

JPEG_chroma_Q = numpy.array(
    [[17,  18,  24,  47,  99,  99,  99,  99],
    [18,  21,  26,  66,  99,  99,  99,  99],
    [24,  26,  56,  99,  99,  99,  99,  99],
    [47,  66,  99,  99,  99,  99,  99,  99],
    [99,  99,  99,  99,  99,  99,  99,  99],
    [99,  99,  99,  99,  99,  99,  99,  99],
    [99,  99,  99,  99,  99,  99,  99,  99],
    [99,  99,  99,  99,  99,  99,  99,  99]])

def watson_slack(b, c00):
    # table of sensitivity values
    t = numpy.array( \
        [1.404,  1.011,  1.169,  1.664,  2.408,  3.433,  4.796,  6.563,\
         1.011,  1.452,  1.323,  1.529,  2.006,  2.716,  3.679,  4.939,\
         1.169,  1.323,  2.241,  2.594,  2.988,  3.649,  4.604,  5.883,\
         1.664,  1.529,  2.594,  3.773,  4.559,  5.305,  6.281,  7.600,\
         2.408,  2.006,  2.988,  4.559,  6.152,  7.463,  8.713, 10.175,\
         3.433,  2.716,  3.649,  5.305,  7.463,  9.625, 11.588, 13.519,\
         4.796,  3.679,  4.604,  6.281,  8.713, 11.588, 14.500, 17.294,\
         6.563,  4.939,  5.883,  7.600, 10.175, 13.519, 17.294, 21.156])

    tl = t * math.pow(b.ravel()[0] / c00, 0.649)
  
    tl[1:] = numpy.maximum(tl[1:], (numpy.abs(b.ravel()[1:])**0.7) * (tl[1:]**0.3))
    return tl.reshape((8, 8))

