import numpy

_fc = numpy.array(
        [[ 1,  1,  1,  1], 
         [ 2,  1, -1, -2], 
         [ 1, -1, -1,  1], 
         [ 1, -2,  2, -1]], numpy.float)
_fct = _fc.T
_fe = numpy.array(
        [[0.25, 0.15811388, 0.25, 0.15811388], 
         [0.15811388, 0.1, 0.15811388, 0.1],
         [0.25, 0.15811388, 0.25, 0.15811388], 
         [0.15811388, 0.1, 0.15811388, 0.1]], numpy.float)

_ic = numpy.array(
        [[1, 1, 1, 0.5], 
         [1, 0.5, -1, -1], 
         [1, -0.5, -1, 1], 
         [1, -1, 1, -0.5]], numpy.float)
_ict = _ic.T         
_ie = numpy.array(
        [[0.25, 0.31622777, 0.25, 0.31622777], 
         [0.31622777, 0.4, 0.31622777, 0.4], 
         [0.25, 0.31622777, 0.25, 0.31622777],
         [0.31622777, 0.4, 0.31622777, 0.4]], numpy.float)

def fdct4x4(b):
    '''
    Compute the approximate 4x4 DCT coefficients of an array 
    as defined by H.264/AVC.
    '''
    global _fc, _fct, _fe
    return numpy.dot(_fc, numpy.dot(b, _fct)) * _fe

def idct4x4(b):
    '''
    Compute the inverse 4x4 DCT of the array.
    '''
    global _ic, _ict, _ie
    return numpy.dot(_ic, numpy.dot(b*_ie, _ict))

