import dct, numpy

def fdctNxN(b):
    '''
    Forward 2D DCT on NxN array.
    '''
    c = dct.__init_dctN(b.shape[0])
    return numpy.dot(c, numpy.dot(b, numpy.transpose(c)))

def idctNxN(b):
    '''
    Inverse 2D DCT on NxN array.
    '''
    c = dct.__init_dctN(b.shape[0])
    return numpy.dot(numpy.transpose(c), numpy.dot(b, c))

